package net.robertboehm.ld24.util;

import net.robertboehm.ld24.entities.PinkiePie;
import net.robertboehm.ld24.scenes.EnhancementsScene;
import net.robertboehm.ld24.scenes.GameOverScene;
import net.robertboehm.ld24.scenes.GameScene;
import net.robertboehm.ld24.scenes.GameWinScene;
import net.robertboehm.ld24.scenes.HelpScene;
import net.robertboehm.ld24.scenes.MenuScene;
import net.robertboehm.ld24.scenes.PauseScreen;
import nme.display.Sprite;
import nme.events.Event;
import nme.Lib;
import org.rygal.audio.Jukebox;
import org.rygal.audio.Sound;
import org.rygal.Game;
import org.rygal.GameObject;
import org.rygal.graphic.AnimatedSprite;
import org.rygal.graphic.Animation;
import org.rygal.util.Storage;

/**
 * ...
 * @author Robert Böhm
 */

class Main extends Sprite {
	
	public static var jukebox:Jukebox;
	
	public static var pinkiePie:GameObject;
	
	public function new() {
		super();
		#if iphone
		Lib.current.stage.addEventListener(Event.RESIZE, init);
		#else
		addEventListener(Event.ADDED_TO_STAGE, init);
		#end
	}
	
	public static function toggleSound():Void {
		if (Sound.getVolume() == 1) {
			Sound.setVolume(0);
			new Storage("sound").put("mute", true);
		} else {
			Sound.setVolume(1);
			new Storage("sound").put("mute", false);
		}
	}

	private function init(e) {
		GameAssets.load();
		
		if (jukebox == null) {
			jukebox = new Jukebox();
			jukebox.addSound(GameAssets.music);
			jukebox.start();
			
			if (new Storage("sound").get("mute", false)) {
				Sound.setVolume(0);
			}
		}
		
		var game:Game = Game.create(2);
		
		if (pinkiePie == null) {
			pinkiePie = new PinkiePie(game);
		}
		
		game.pauseScene = new PauseScreen();
		//game.fixedTimestep = 1000 / 60;
		game.registerScene(new MenuScene(), "menu");
		game.registerScene(new HelpScene(), "help");
		game.registerScene(new GameOverScene(), "gameover");
		game.registerScene(new GameWinScene(), "gamewin");
		game.registerScene(new EnhancementsScene(), "enhancements");
		game.registerScene(new GameScene("01", "02"), "game01");
		game.registerScene(new GameScene("02", "03"), "game02");
		game.registerScene(new GameScene("03", "04"), "game03");
		game.registerScene(new GameScene("04", "05"), "game04");
		game.registerScene(new GameScene("05", "06"), "game05");
		game.registerScene(new GameScene("06", "07"), "game06");
		game.registerScene(new GameScene("07", "08"), "game07");
		game.registerScene(new GameScene("08", "09"), "game08");
		game.registerScene(new GameScene("09"), "game09");
		game.useScene("menu");
		
		stage.addChild(game.getDisplayObject());
	}
	
	static public function main() {
		var stage = Lib.current.stage;
		stage.scaleMode = nme.display.StageScaleMode.NO_SCALE;
		stage.align = nme.display.StageAlign.TOP_LEFT;
		
		Lib.current.addChild(new Main());
	}
	
}
