package net.robertboehm.ld24.util;

import org.rygal.audio.Sound;
import org.rygal.graphic.Font;
import org.rygal.graphic.Spritesheet;
import org.rygal.graphic.Texture;

/**
 * ...
 * @author Robert Böhm
 */

class GameAssets {
	
	public static var transparentSpritesheet(default, null):Spritesheet;
	
	public static var spritesheet(default, null):Spritesheet;
	
	public static var spritesheetTinyEnemy(default, null):Spritesheet;
	
	public static var spritesheetNormalEnemy(default, null):Spritesheet;
	
	public static var spritesheetBigEnemy(default, null):Spritesheet;
	
	public static var projectile(default, null):Texture;
	
	public static var hud(default, null):Texture;
	
	public static var menu(default, null):Texture;
	
	public static var background(default, null):Texture;
	
	public static var gaben(default, null):Texture;
	
	public static var help(default, null):Texture;
	
	public static var pinkiePie(default, null):Spritesheet;
	
	public static var font(default, null):Font;
	
	public static var bigFont(default, null):Font;
	
	public static var largeFont(default, null):Font;
	
	
	public static var attackSound(default, null):Sound;
	public static var buildingSound(default, null):Sound;
	public static var explosionSound(default, null):Sound;
	public static var killSound(default, null):Sound;
	public static var moneySound(default, null):Sound;
	public static var selectSound(default, null):Sound;
	public static var shootSound(default, null):Sound;
	public static var music(default, null):Sound;
	public static var pinkiePieMusic(default, null):Sound;
	
	static public var soundVolume:Float = 0.25;
	static public var shotVolume:Float = 0.5;
	
	static public var playShot:Bool = true;
	static public var playKill:Bool = true;
	static public var playAttack:Bool = true;
	static public var playMoney:Bool = true;
	
	static public inline var MIN_DISTANCEFACTOR:Float = 0.35;
	
	
	
	public static function load():Void {
		transparentSpritesheet = Spritesheet.fromSpriteSize(Texture.fromAssets("images/spritesheet_transparent.png"), 32, 32);
		spritesheet = Spritesheet.fromSpriteSize(Texture.fromAssets("images/spritesheet.png"), 32, 32);
		spritesheetTinyEnemy = new Spritesheet(Texture.fromAssets("images/tinyenemy.png"), 4, 5);
		spritesheetNormalEnemy = new Spritesheet(Texture.fromAssets("images/normalenemy.png"), 4, 5);
		spritesheetBigEnemy = new Spritesheet(Texture.fromAssets("images/bigenemy.png"), 4, 5);
		projectile = Texture.fromAssets("images/projectile.png");
		hud = Texture.fromAssets("images/hud.png");
		menu = Texture.fromAssets("images/menu.png");
		background = Texture.fromAssets("images/background.png");
		help = Texture.fromAssets("images/help.png");
		gaben = Texture.fromAssets("images/gaben.png");
		pinkiePie = new Spritesheet(Texture.fromAssets("images/pinkiepie.png"), 16, 1);
		font = Font.fromAssets("fonts/nokiafc22.ttf", 8);
		bigFont = Font.fromAssets("fonts/nokiafc22.ttf", 16);
		largeFont = Font.fromAssets("fonts/nokiafc22.ttf", 24);
		
		music = Sound.fromAssets("music/music.mp3");
		pinkiePieMusic = Sound.fromAssets("music/pinkiepie.mp3");
		
		
		attackSound = Sound.fromAssets("sounds/attack.wav");
		buildingSound = Sound.fromAssets("sounds/building.wav");
		explosionSound = Sound.fromAssets("sounds/explosion.wav");
		killSound = Sound.fromAssets("sounds/kill.wav");
		moneySound = Sound.fromAssets("sounds/money.wav");
		selectSound = Sound.fromAssets("sounds/select.wav");
		shootSound = Sound.fromAssets("sounds/shoot.wav");
	}
	
}