package net.robertboehm.ld24.util;
import net.robertboehm.ld24.entities.buildings.Building;
import net.robertboehm.ld24.entities.buildings.CrystalExtractor;
import net.robertboehm.ld24.entities.buildings.CrystalMine;
import net.robertboehm.ld24.entities.buildings.Turret;
import net.robertboehm.ld24.entities.enemies.Enemy;

/**
 * ...
 * @author Robert Böhm
 */

class BasicEnemyAI implements EnemyAI {
	
	public static inline var MAX_ATTACK_RANGE:Float = 70;
	
	public static inline var MAX_MINE_ATTACK_RANGE:Float = 120;

	public function new() {
	}
	
	public function think(enemy:Enemy):Void {
		var target:Building = enemy.scene.getClosestBuildingOfType(CrystalExtractor, enemy);
		// Find closest crystal extractor...
		
		if (target == null || enemy.getDistanceTo(target.x + target.width / 2, target.y + target.height / 2) > MAX_ATTACK_RANGE) {
			
			// However, check if there's a turret nearby that you could attack...
			var t:Turret = enemy.scene.getClosestBuildingOfType(Turret, enemy);
			var tDistance:Float = t == null ? 0 : enemy.getDistanceTo(t.x + t.width / 2, t.y + t.height / 2);
			if (tDistance > MAX_ATTACK_RANGE) t = null;
			
			// Or check if there's a mine nearby that you could attack...
			var m:CrystalMine = enemy.scene.getClosestBuildingOfType(CrystalMine, enemy);
			var mDistance:Float = m == null ? 0 : enemy.getDistanceTo(m.x + m.width / 2, m.y + m.height / 2);
			if (mDistance > MAX_MINE_ATTACK_RANGE) m = null;
			
			if (t != null && m == null) {
				target = t;
			} else if (t == null && m != null) {
				target = m;
			} else if (t != null && m != null) {
				if (tDistance < 40) {
					target = t;
				} else {
					target = m;
				}
			}
		}
		
		if (target != null) {
			// Move towards the target:
			enemy.movement = Math.max(0, enemy.getDistanceTo(target.x + target.width / 2, target.y + target.height / 2) - 8);
			enemy.movementDirection = enemy.getDirectionTo(target.x + target.width / 2, target.y + target.height / 2);
		}
	}
	
}