package net.robertboehm.ld24.scenes;

import net.robertboehm.ld24.util.GameAssets;
import net.robertboehm.ld24.util.Main;
import org.rygal.Game;
import org.rygal.GameTime;
import org.rygal.graphic.Canvas;
import org.rygal.graphic.Color;
import org.rygal.Scene;
import org.rygal.ui.Button;
import org.rygal.ui.ButtonEvent;
import org.rygal.util.Storage;

/**
 * ...
 * @author Robert Böhm
 */

class MenuScene extends Scene {
	
	var continueButton:Button;
	var newGameButton:Button;
	
	public function new() {
		super();
	}
	
	
	override public function load(game:Game):Void {
		super.load(game);
		
		continueButton = new Button(game, 120, 22, GameAssets.bigFont, "Continue", Color.LIGHT_GRAY, Color.BLACK, Color.WHITE, Color.BLACK, Color.DIM_GRAY, Color.BLACK);
		newGameButton = new Button(game, 120, 22, GameAssets.bigFont, "New game", Color.LIGHT_GRAY, Color.BLACK, Color.WHITE, Color.BLACK, Color.DIM_GRAY, Color.BLACK);
		
		continueButton.x = game.width / 2 - continueButton.width / 2;
		newGameButton.x = game.width / 2 - newGameButton.width / 2;
		continueButton.y = game.height / 2 + 26;
		newGameButton.y = game.height / 2 + 26 + continueButton.height + 4;
		
		continueButton.addEventListener(ButtonEvent.CLICKED, onContinue);
		newGameButton.addEventListener(ButtonEvent.CLICKED, onNewGame);
		
		var storage:Storage = new Storage("savegame");
		var level:String = storage.get("level");
		if (level != null) {
			this.addChild(continueButton);
		}
		this.addChild(newGameButton);
	}
	
	private function onContinue(e:ButtonEvent):Void {
		GameAssets.selectSound.play(GameAssets.soundVolume);
		
		var storage:Storage = new Storage("savegame");
		if (storage.isset("nextLevel")) {
			game.useScene("enhancements");
		} else {
			game.useScene("game" + storage.get("level"));
		}
	}
	
	private function onNewGame(e:ButtonEvent):Void {
		GameAssets.selectSound.play(GameAssets.soundVolume);
		
		game.useScene("help");
	}
	
	override public function unload():Void {
		super.unload();
		
		continueButton.dispose();
		newGameButton.dispose();
	}
	
	override public function update(time:GameTime):Void {
		Main.pinkiePie.update(time);
		
		super.update(time);
	}
	
	override public function draw(screen:Canvas):Void {
		screen.draw(GameAssets.menu, 0, 0);
		
		super.draw(screen);
		
		Main.pinkiePie.draw(screen);
		
	}
	
}
