package net.robertboehm.ld24.scenes;

import net.robertboehm.ld24.util.Enhancements;
import net.robertboehm.ld24.util.GameAssets;
import net.robertboehm.ld24.util.Main;
import org.rygal.Game;
import org.rygal.GameTime;
import org.rygal.graphic.Canvas;
import org.rygal.graphic.Color;
import org.rygal.Scene;
import org.rygal.ui.Button;
import org.rygal.ui.ButtonEvent;
import org.rygal.util.Storage;

/**
 * ...
 * @author Robert Böhm
 */

class HelpScene extends Scene {
	
	var startButton:Button;
	
	public function new() {
		super();
	}
	
	
	override public function load(game:Game):Void {
		super.load(game);
		
		startButton = new Button(game, 100, 22, GameAssets.bigFont, "Start game", Color.LIGHT_GRAY, Color.BLACK, Color.WHITE, Color.BLACK, Color.DIM_GRAY, Color.BLACK);
		
		startButton.x = game.width / 2 - startButton.width / 2;
		startButton.y = game.height / 2 + 84;
		
		startButton.addEventListener(ButtonEvent.CLICKED, onStart);
		
		this.addChild(startButton);
	}
	
	private function onStart(e:ButtonEvent):Void {
		GameAssets.selectSound.play(GameAssets.soundVolume);
		
		// Overwrite old enhancements:
		new Enhancements().store(new Storage("savegame"));
		
		var storage:Storage = new Storage("savegame");
		storage.put("level", "01");
		storage.put("speed", false);
		
		game.useScene("game01");
	}
	
	override public function unload():Void {
		super.unload();
		
		startButton.dispose();
	}
	
	override public function update(time:GameTime):Void {
		Main.pinkiePie.update(time);
		
		super.update(time);
	}
	
	override public function draw(screen:Canvas):Void {
		screen.draw(GameAssets.help, 0, 0);
		
		super.draw(screen);
		
		Main.pinkiePie.draw(screen);
	}
	
}
