package net.robertboehm.ld24.scenes;

import net.robertboehm.ld24.util.Enhancements;
import net.robertboehm.ld24.util.GameAssets;
import net.robertboehm.ld24.util.Main;
import nme.Lib;
import org.rygal.Game;
import org.rygal.GameTime;
import org.rygal.graphic.Canvas;
import org.rygal.graphic.Color;
import org.rygal.graphic.Font;
import org.rygal.Scene;
import org.rygal.ui.Button;
import org.rygal.ui.ButtonEvent;
import org.rygal.ui.Label;
import org.rygal.util.Storage;

/**
 * ...
 * @author Robert Böhm
 */

class GameWinScene extends Scene {
	
	var retryButton:Button;
	var gameWinLabel:Label;
	var gameWinSublabel:Label;
	var gameWinReminder:Label;
	
	private var _waiting:Float;
	private var _shake:Float;
	
	public function new() {
		super();
	}
	
	
	override public function load(game:Game):Void {
		super.load(game);
		
		gameWinLabel = new Label(GameAssets.largeFont, "Congratulations", Font.CENTER, Color.WHITE, 1, game.width / 2, 40);
		gameWinSublabel = new Label(GameAssets.bigFont, "You haz won teh gamez!", Font.CENTER, Color.LIGHT_GRAY, 1, game.width / 2, 80);
		gameWinReminder = new Label(GameAssets.font, "Make sure to submit a vote :)", Font.CENTER, Color.LIGHT_GRAY, 1, game.width / 2, 120);
		
		retryButton = new Button(game, 80, 22, GameAssets.bigFont, "Play again", Color.LIGHT_GRAY, Color.BLACK, Color.WHITE, Color.BLACK, Color.DIM_GRAY, Color.BLACK);
		
		retryButton.x = game.width / 2 - retryButton.width / 2;
		retryButton.y = game.height / 2 + 52;
		
		retryButton.addEventListener(ButtonEvent.CLICKED, onRetry);
		
		this.addChild(gameWinLabel);
		this.addChild(gameWinSublabel);
		this.addChild(gameWinReminder);
		this.addChild(retryButton);
		
		_waiting = 3;
		_shake = -1;
	}
	
	private function onRetry(e:ButtonEvent):Void {
		GameAssets.selectSound.play(GameAssets.soundVolume);
		
		// Overwrite old enhancements:
		new Enhancements().store(new Storage("savegame"));
		
		var storage:Storage = new Storage("savegame");
		storage.put("level", "01");
		storage.put("speed", false);
		
		game.useScene("game01");
	}
	
	override public function unload():Void {
		super.unload();
		
		retryButton.dispose();
	}
	
	override public function update(time:GameTime):Void {
		Main.pinkiePie.update(time);
		
		super.update(time);
		
		if (retryButton.bounds.contains(game.mouse.x, game.mouse.y)) {
			_shake = -1;
			_waiting = 0;
		}
		
		if (_shake >= Math.PI * 4) {
			_shake = -1;
			retryButton.y = game.height / 2 + 52;
		}
		
		if (_waiting > 0) {
			_waiting -= time.elapsedS;
			if (_waiting <= 0) {
				// Shake the button
				_shake = 0;
			}
		}
		
		if (_shake >= 0) {
			_shake += time.elapsedS * 10;
			retryButton.y = game.height / 2 + 52 + Math.sin(_shake) * 10;
		}
	}
	
	override public function draw(screen:Canvas):Void {
		screen.draw(GameAssets.background, 0, 0);
		
		super.draw(screen);
		
		Main.pinkiePie.draw(screen);
	}
	
}
