package net.robertboehm.ld24.scenes;

import net.robertboehm.ld24.util.Enhancements;
import net.robertboehm.ld24.util.GameAssets;
import net.robertboehm.ld24.util.Main;
import org.rygal.Game;
import org.rygal.GameTime;
import org.rygal.graphic.Canvas;
import org.rygal.graphic.Color;
import org.rygal.graphic.Font;
import org.rygal.input.MouseEvent;
import org.rygal.Scene;
import org.rygal.ui.Label;
import org.rygal.util.Storage;

/**
 * ...
 * @author Robert Böhm
 */

class EnhancementsScene extends Scene {
	
	var titleLabel:Label;
	
	var nameLabel:Label;
	
	var infoLabel:Label;
	
	var enhancements:Enhancements;
	
	
	public function new() {
		super();
	}
	
	
	override public function load(game:Game):Void {
		super.load(game);
		
		titleLabel = new Label(GameAssets.bigFont, "Choose an enhancement", Font.CENTER, Color.LIGHT_GRAY, 1, game.width / 2, 15);
		nameLabel = new Label(GameAssets.bigFont, "", Font.CENTER, Color.LIGHT_GRAY, 1, game.width / 2, game.height / 2 + 36);
		infoLabel = new Label(GameAssets.font, "", Font.CENTER, Color.LIGHT_GRAY, 1, game.width / 2, game.height / 2 + 60);
		
		this.addChild(titleLabel);
		this.addChild(nameLabel);
		this.addChild(infoLabel);
		
		this.enhancements = new Enhancements();
		enhancements.restore(new Storage("savegame"));
		
		game.mouse.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
	}
	
	override public function unload():Dynamic {
		super.unload();
		
		game.mouse.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
	}
	
	private function onMouseUp(e:MouseEvent):Void {
		var cols:Int = 4;
		var rows:Int = 2;
		var xOffset:Float = game.width / 2 - (GameAssets.spritesheet.spriteWidth * cols) / 2;
		var yOffset:Float = game.height / 3 - (GameAssets.spritesheet.spriteHeight * rows) / 2;
		if ((game.mouse.x - xOffset) >= 0 && (game.mouse.y - yOffset) >= 0) {
			var x:Int = Std.int((game.mouse.x - xOffset) / GameAssets.spritesheet.spriteWidth);
			var y:Int = Std.int((game.mouse.y - yOffset) / GameAssets.spritesheet.spriteHeight);
			if (x >= 0 && y >= 0 && x < cols && y < rows) {
				var status:Bool = false;
				if (x == 0 && y == 0) { status = enhancements.explorer;
				} else if (x == 1 && y == 0) { status = enhancements.ai;
				} else if (x == 2 && y == 0) { status = enhancements.doubleTheTrouble;
				} else if (x == 3 && y == 0) { status = enhancements.gunSteroids;
				} else if (x == 0 && y == 1) { status = enhancements.fastAim;
				} else if (x == 1 && y == 1) { status = enhancements.fistFight;
				} else if (x == 2 && y == 1) { status = enhancements.piercingSpeed;
				} else if (x == 3 && y == 1) { status = enhancements.supersonicFire; }
				if (!status) {
					GameAssets.selectSound.play(GameAssets.soundVolume);
					
					if (x == 0 && y == 0) { enhancements.explorer = true;
					} else if (x == 1 && y == 0) { enhancements.ai = true;
					} else if (x == 2 && y == 0) { enhancements.doubleTheTrouble = true;
					} else if (x == 3 && y == 0) { enhancements.gunSteroids = true;
					} else if (x == 0 && y == 1) { enhancements.fastAim = true;
					} else if (x == 1 && y == 1) { enhancements.fistFight = true;
					} else if (x == 2 && y == 1) { enhancements.piercingSpeed = true;
					} else if (x == 3 && y == 1) { enhancements.supersonicFire = true; }
					var s:Storage = new Storage("savegame");
					enhancements.store(s);
					game.useScene("game" + s.get("nextLevel"));
					s.put("level", s.get("nextLevel"));
					s.unset("nextLevel");
				}
			}
		}
	}
	
	override public function update(time:GameTime):Void {
		Main.pinkiePie.update(time);
		
		super.update(time);
		
		var names:Array<Array<String>> = [
				["Explorer", "AI - Ammo Intelligence", "Double the Trouble", "Gun Steroids"],
				["Quick Aim", "Fistfight", "Piercing speed", "Supersonic fire"]
			];
		
		var descriptions:Array<Array<String>> = [
				[
					"Reveals additional crystal deposits.",
					"Projectiles seek for another target\nif their original one died.",
					"Gun Turrets can attack two enemies\nsimultaneously.",
					"Gun Turrets' projectiles deal more\ndamage."
				],
				[
					"Sniper Turrets have increased fire\nrates.",
					"Sniper Turrets have increased damage\non closer enemies.",
					"Rapid Turrets' projectiles hit up to\n3 targets.",
					"Rapid Turrets fire even faster."
				]
			];
		
		var cols:Int = 4;
		var rows:Int = 2;
		var xOffset:Float = game.width / 2 - (GameAssets.spritesheet.spriteWidth * cols) / 2;
		var yOffset:Float = game.height / 3 - (GameAssets.spritesheet.spriteHeight * rows) / 2;
		nameLabel.text = "";
		infoLabel.text = "";
		
		if ((game.mouse.x - xOffset) >= 0 && (game.mouse.y - yOffset) >= 0) {
			var x:Int = Std.int((game.mouse.x - xOffset) / GameAssets.spritesheet.spriteWidth);
			var y:Int = Std.int((game.mouse.y - yOffset) / GameAssets.spritesheet.spriteHeight);
			if (x >= 0 && y >= 0 && x < cols && y < rows) {
				nameLabel.text = names[y][x];
				infoLabel.text = descriptions[y][x];
			}
		}
	}
	
	override public function draw(screen:Canvas):Void {
		screen.draw(GameAssets.background, 0, 0);
		
		super.draw(screen);
		
		var cols:Int = 4;
		var rows:Int = 2;
		var x:Float = screen.width / 2 - (GameAssets.spritesheet.spriteWidth * cols) / 2;
		var y:Float = screen.height / 3 - (GameAssets.spritesheet.spriteHeight * rows) / 2;
		
		for (c in 0...cols) {
			for (r in 0...rows) {
				var status:Bool = false;
				if (c == 0 && r == 0) { status = enhancements.explorer;
				} else if (c == 1 && r == 0) { status = enhancements.ai;
				} else if (c == 2 && r == 0) { status = enhancements.doubleTheTrouble;
				} else if (c == 3 && r == 0) { status = enhancements.gunSteroids;
				} else if (c == 0 && r == 1) { status = enhancements.fastAim;
				} else if (c == 1 && r == 1) { status = enhancements.fistFight;
				} else if (c == 2 && r == 1) { status = enhancements.piercingSpeed;
				} else if (c == 3 && r == 1) { status = enhancements.supersonicFire; }
				
				if (!status) {
					screen.draw(GameAssets.spritesheet.getTexture(3, 3), x + c * GameAssets.spritesheet.spriteWidth, y + r * GameAssets.spritesheet.spriteHeight);
				}
				screen.draw(GameAssets.spritesheet.getTexture(c, 6 + r), x + c * GameAssets.spritesheet.spriteWidth, y + r * GameAssets.spritesheet.spriteHeight);
			}
		}
		
		Main.pinkiePie.draw(screen);
	}
	
}
