package net.robertboehm.ld24.entities.enemies;

import net.robertboehm.ld24.scenes.GameScene;
import net.robertboehm.ld24.util.BasicEnemyAI;
import net.robertboehm.ld24.util.GameAssets;
import org.rygal.Game;
import org.rygal.GameTime;
import org.rygal.graphic.Animation;
import org.rygal.Scene;

/**
 * ...
 * @author Robert Böhm
 */

class NormalEnemy extends Enemy {
	
	public var game(default, null):Game;
	
	public function new(scene:GameScene, modifier:Float = 0, x:Float = 0, y:Float = 0) {
		super(scene, x, y);
		
		this.ai = new BasicEnemyAI();
		this.speed = 100;
		this.health = 40 + modifier * 50;
		this.damage = 25 + modifier * 5;
		this.attackRate = 500;
		
		this.registerAnimation("moveUp", Animation.fromSpritesheet(100, GameAssets.spritesheetNormalEnemy, 0, 4));
		this.registerAnimation("moveDown", Animation.fromSpritesheet(100, GameAssets.spritesheetNormalEnemy, 4, 8));
		this.registerAnimation("moveRight", Animation.fromSpritesheet(100, GameAssets.spritesheetNormalEnemy, 8, 12));
		this.registerAnimation("moveLeft", Animation.fromSpritesheet(100, GameAssets.spritesheetNormalEnemy, 12, 16));
		this.registerAnimation("idleUp", Animation.fromSpritesheet(100, GameAssets.spritesheetNormalEnemy, 3, 4));
		this.registerAnimation("idleDown", Animation.fromSpritesheet(100, GameAssets.spritesheetNormalEnemy, 7, 8));
		this.registerAnimation("idleRight", Animation.fromSpritesheet(100, GameAssets.spritesheetNormalEnemy, 11, 12));
		this.registerAnimation("idleLeft", Animation.fromSpritesheet(100, GameAssets.spritesheetNormalEnemy, 15, 16));
		this.registerAnimation("die", Animation.fromSpritesheet(50, GameAssets.spritesheetNormalEnemy, 16, 20));
	}
	
}