package net.robertboehm.ld24.entities.enemies;

import net.robertboehm.ld24.scenes.GameScene;
import net.robertboehm.ld24.util.BasicEnemyAI;
import net.robertboehm.ld24.util.GameAssets;
import org.rygal.Game;
import org.rygal.GameTime;
import org.rygal.graphic.Animation;
import org.rygal.Scene;

/**
 * ...
 * @author Robert Böhm
 */

class BigEnemy extends Enemy {
	
	public var game(default, null):Game;
	
	public function new(scene:GameScene, modifier:Float = 0, x:Float = 0, y:Float = 0) {
		super(scene, x, y);
		
		this.ai = new BasicEnemyAI();
		this.speed = 15 + modifier * 15;
		this.health = 500 + modifier * 1000;
		this.damage = 100 + modifier * 50;
		this.attackRate = 1500;
		
		this.registerAnimation("moveUp", Animation.fromSpritesheet(250, GameAssets.spritesheetBigEnemy, 0, 4));
		this.registerAnimation("moveDown", Animation.fromSpritesheet(250, GameAssets.spritesheetBigEnemy, 4, 8));
		this.registerAnimation("moveRight", Animation.fromSpritesheet(250, GameAssets.spritesheetBigEnemy, 8, 12));
		this.registerAnimation("moveLeft", Animation.fromSpritesheet(250, GameAssets.spritesheetBigEnemy, 12, 16));
		this.registerAnimation("idleUp", Animation.fromSpritesheet(250, GameAssets.spritesheetBigEnemy, 3, 4));
		this.registerAnimation("idleDown", Animation.fromSpritesheet(250, GameAssets.spritesheetBigEnemy, 7, 8));
		this.registerAnimation("idleRight", Animation.fromSpritesheet(250, GameAssets.spritesheetBigEnemy, 11, 12));
		this.registerAnimation("idleLeft", Animation.fromSpritesheet(250, GameAssets.spritesheetBigEnemy, 15, 16));
		this.registerAnimation("die", Animation.fromSpritesheet(50, GameAssets.spritesheetBigEnemy, 16, 20));
	}
	
}