package net.robertboehm.ld24.entities.buildings;

import net.robertboehm.ld24.entities.CoolList;
import net.robertboehm.ld24.entities.enemies.Enemy;
import net.robertboehm.ld24.entities.EnemyList;
import net.robertboehm.ld24.entities.Projectile;
import net.robertboehm.ld24.scenes.GameScene;
import net.robertboehm.ld24.util.GameAssets;
import org.rygal.GameTime;
import org.rygal.graphic.Texture;

/**
 * ...
 * @author Robert Böhm
 */

class Turret extends Building {
	
	private var projectileList:CoolList<Projectile>;
	private var enemyList:EnemyList;
	private var range:Float;
	private var projectileSpeed:Float;
	private var piercing:Int;
	private var damage:Float;
	private var shootDelay:Float;
	private var projectiles:Int = 1;
	private var seekingProjectiles:Bool = true;
	
	private var _shootCooldown:Float = 0;
	
	
	public function new(texture:Texture, scene:GameScene, health:Float) {
		super(scene, texture, health);
		
		this.projectileList = scene.projectiles;
		this.enemyList = scene.enemies;
		this.seekingProjectiles = scene.enhancements.ai;
	}
	
	
	public function shoot():Void {
		var nearestEnemies:Array<Enemy> = this.enemyList.getNearestEnemies(this.x + this.width / 2, this.y + this.height / 2, projectiles, range);
		if (nearestEnemies.length > 0 && GameAssets.playShot) {
			var distanceFactor:Float = scene.getDistanceVolumeFactor(this.x + this.width / 2, this.y + this.height / 2);
			if (distanceFactor > GameAssets.MIN_DISTANCEFACTOR) {
				GameAssets.shootSound.play(GameAssets.soundVolume * GameAssets.shotVolume * distanceFactor);
				GameAssets.playShot = false;
			}
		}
		
		for (enemy in nearestEnemies) {
			projectileList.spawn(new Projectile(this.x + this.width / 2, this.y + this.height / 2, this.projectileSpeed, enemy, this.damage, enemyList, seekingProjectiles, this.range, piercing));
		}
	}
	
	override public function update(time:GameTime):Void {
		super.update(time);
		
		_shootCooldown -= time.elapsedMs;
		while (_shootCooldown <= 0) {
			shoot();
			_shootCooldown += shootDelay;
		}
	}
	
	override public function clone():Building {
		return new Turret(texture, scene, this.maxHealth);
	}
	
}