package net.robertboehm.ld24.entities.buildings;

import net.robertboehm.ld24.entities.enemies.Enemy;
import net.robertboehm.ld24.entities.Projectile;
import net.robertboehm.ld24.scenes.GameScene;
import net.robertboehm.ld24.util.GameAssets;
import org.rygal.graphic.Texture;

/**
 * ...
 * @author Robert Böhm
 */

class SniperTurret extends Turret {
	
	public static inline var NAME:String = "Sniper Turret";
	
	public static inline var PRICE:Int = 150;
	
	
	public function new(scene:GameScene) {
		super(GameAssets.spritesheet.getTexture(2, 2), scene, 500);
		
		range = 240;
		projectileSpeed = 300;
		piercing = 1;
		damage = 200;
		shootDelay = scene.enhancements.fastAim ? 1250 : 2000;
	}
	
	override public function shoot():Void {
		var nearestEnemies:Array<Enemy> = this.enemyList.getNearestEnemies(this.x + this.width / 2, this.y + this.height / 2, projectiles, range);
		if (nearestEnemies.length > 0 && GameAssets.playShot) {
			var distanceFactor:Float = scene.getDistanceVolumeFactor(this.x + this.width / 2, this.y + this.height / 2);
			if (distanceFactor > GameAssets.MIN_DISTANCEFACTOR) {
				GameAssets.shootSound.play(GameAssets.soundVolume * GameAssets.shotVolume * distanceFactor);
				GameAssets.playShot = false;
			}
		}
		
		for (enemy in nearestEnemies) {
			if (scene.enhancements.fistFight && enemy.getDistanceTo(x + width / 2, y + height / 2) <= 60) {
				// Increased damage
				projectileList.spawn(new Projectile(this.x + this.width / 2, this.y + this.height / 2, this.projectileSpeed, enemy, this.damage * 2, enemyList, seekingProjectiles, this.range, piercing));
			} else {
				projectileList.spawn(new Projectile(this.x + this.width / 2, this.y + this.height / 2, this.projectileSpeed, enemy, this.damage, enemyList, seekingProjectiles, this.range, piercing));
			}
		}
	}
	
	override public function getPrice():Int {
		return SniperTurret.PRICE;
	}
	
	override public function clone():Building {
		return new SniperTurret(scene);
	}
	
}