package net.robertboehm.ld24.entities.buildings;

import net.robertboehm.ld24.scenes.GameScene;
import net.robertboehm.ld24.util.GameAssets;
import org.rygal.graphic.Texture;

/**
 * ...
 * @author Robert Böhm
 */

class RapidTurret extends Turret {
	
	public static inline var NAME:String = "Rapid Turret";
	
	public static inline var PRICE:Int = 125;
	
	
	public function new(scene:GameScene) {
		super(GameAssets.spritesheet.getTexture(1, 2), scene, 500);
		
		range = 65;
		projectileSpeed = 200;
		piercing = scene.enhancements.piercingSpeed ? 3 : 1;
		damage = scene.enhancements.supersonicFire ? 7 : 9;
		shootDelay = scene.enhancements.supersonicFire ? 100 : 200;
	}
	
	
	override public function getPrice():Int {
		return RapidTurret.PRICE;
	}
	
	override public function clone():Building {
		return new RapidTurret(scene);
	}
	
}