package net.robertboehm.ld24.entities.buildings;

import net.robertboehm.ld24.scenes.GameScene;
import net.robertboehm.ld24.util.GameAssets;
import org.rygal.graphic.Texture;

/**
 * ...
 * @author Robert Böhm
 */

class GunTurret extends Turret {
	
	public static inline var NAME:String = "Gun Turret";
	
	public static inline var PRICE:Int = 80;
	
	
	public function new(scene:GameScene) {
		super(GameAssets.spritesheet.getTexture(0, 2), scene, 500);
		
		range = 90;
		projectileSpeed = 200;
		piercing = 1;
		damage = scene.enhancements.gunSteroids ? 25 : 15;
		shootDelay = 500;
		projectiles = scene.enhancements.doubleTheTrouble ? 2 : 1;
	}
	
	
	override public function getPrice():Int {
		return GunTurret.PRICE;
	}
	
	override public function clone():Building {
		return new GunTurret(scene);
	}
	
}