package net.robertboehm.ld24.entities.buildings;

import net.robertboehm.ld24.entities.buildings.Building;
import net.robertboehm.ld24.scenes.GameScene;
import net.robertboehm.ld24.util.GameAssets;
import org.rygal.GameTime;

/**
 * ...
 * @author Robert Böhm
 */

class CrystalMine extends Building {
	
	public static inline var NAME:String = "Crystal Mine";
	
	public static inline var PRICE:Int = 100;
	
	public static inline var INCOME_RATE:Float = 0.5;
	
	public static inline var INCOME:Float = 1;
	
	
	private var _incomeCooldown:Float = INCOME_RATE;
	
	
	public function new(scene:GameScene) {
		super(scene, GameAssets.spritesheet.getTexture(3, 0), 500);
	}
	
	override public function update(time:GameTime):Void {
		super.update(time);
		
		_incomeCooldown -= time.elapsedS;
		while (_incomeCooldown <= 0) {
			scene.crystals += INCOME;
			
			_incomeCooldown += INCOME_RATE;
		}
	}
	
	override public function getPrice():Int {
		return CrystalMine.PRICE;
	}
	
	override public function clone():Building {
		return new CrystalMine(scene);
	}
	
}