package net.robertboehm.ld24.entities.buildings;

import net.robertboehm.ld24.entities.buildings.Building;
import net.robertboehm.ld24.scenes.GameScene;
import net.robertboehm.ld24.util.GameAssets;
import org.rygal.GameTime;

/**
 * ...
 * @author Robert Böhm
 */

class CrystalExtractor extends Building {
	
	public static inline var NAME:String = "Crystal Extractor";
	
	public static inline var PRICE:Int = 0;
	
	
	public function new(scene:GameScene, x:Float = 0, y:Float = 0) {
		super(scene, GameAssets.spritesheet.getTexture(3, 1), 3000);
		
		this.healthRegeneration = 0;
		this.x = x;
		this.y = y;
	}
	
	override public function getPrice():Int {
		return CrystalMine.PRICE;
	}
	
	override public function clone():Building {
		return new CrystalMine(scene);
	}
	
}