package net.robertboehm.ld24.entities.buildings;

import net.robertboehm.ld24.scenes.GameScene;
import net.robertboehm.ld24.util.GameAssets;
import net.robertboehm.ld24.util.Livable;
import org.rygal.GameTime;
import org.rygal.graphic.Canvas;
import org.rygal.graphic.Color;
import org.rygal.graphic.Sprite;
import org.rygal.graphic.Texture;

/**
 * ...
 * @author Robert Böhm
 */

class Building extends Sprite, implements Livable {
	
	static public inline var SELL_FACTOR:Float = 0.5;
	
	
	private var scene:GameScene;
	public var maxHealth:Float;
	public var health:Float;
	public var healthRegeneration:Float = 0.005;
	
	
	public function new(scene:GameScene, texture:Texture, health:Float) {
		super(texture);
		
		this.scene = scene;
		this.maxHealth = health;
		this.health = health;
	}
	
	
	public function isDead():Bool {
		return this.health <= 0;
	}
	
	public function hit(damage:Float):Void {
		if (GameAssets.playAttack) {
			var distanceFactor:Float = scene.getDistanceVolumeFactor(this.x + this.width / 2, this.y + this.height / 2);
			if (distanceFactor > GameAssets.MIN_DISTANCEFACTOR) {
				GameAssets.attackSound.play(GameAssets.soundVolume * distanceFactor);
				GameAssets.playAttack = false;
			}
		}
		
		health -= damage;
		if (health < 0)
			health = 0;
	}
	
	public function getPrice():Int {
		return 0;
	}
	
	public function clone():Building {
		return new Building(this.scene, this.texture, this.maxHealth);
	}
	
	override public function update(time:GameTime):Void {
		super.update(time);
		
		this.health += (this.maxHealth * this.healthRegeneration) * time.elapsedS;
		if (this.health > this.maxHealth) {
			this.health = this.maxHealth;
		}
	}
	
	override public function draw(screen:Canvas):Void {
		super.draw(screen);
		screen.fillRect(0xFFFF0000, this.x + 6, this.y + this.height - 8, this.width - 12, 2);
		screen.fillRect(0xFF009900, this.x + 6, this.y + this.height - 8, (this.width - 12) * (this.health / this.maxHealth), 2);
	}
	
	public function getPriceFactor():Float {
		return health / maxHealth;
	}
	
}