package net.robertboehm.ld24.entities;

import net.robertboehm.ld24.entities.enemies.Enemy;
import net.robertboehm.ld24.util.GameAssets;
import net.robertboehm.ld24.util.Livable;
import org.rygal.GameTime;
import org.rygal.graphic.Sprite;

/**
 * ...
 * @author Robert Böhm
 */

class Projectile extends Sprite, implements Livable {
	
	public var speed:Float;
	public var target:Enemy;
	public var damage:Float;
	public var otherEnemies:EnemyList;
	public var previousEnemies:Array<Enemy>;
	public var seekRange:Float;
	public var pierceAmount:Int;
	public var seeking:Bool;
	
	private var _isDead:Bool = false;
	
	
	public function new(x:Float, y:Float, speed:Float, target:Enemy, damage:Float, otherEnemies:EnemyList, seeking:Bool, seekRange:Float, pierceAmount:Int) {
		super(GameAssets.projectile, x, y);
		
		this.speed = speed;
		this.target = target;
		this.damage = damage;
		this.otherEnemies = otherEnemies;
		this.previousEnemies = new Array<Enemy>();
		this.previousEnemies.push(target);
		this.seeking = seeking;
		this.seekRange = seekRange;
		this.pierceAmount = pierceAmount;
	}
	
	
	public function kill():Void {
		this._isDead = true;
	}
	
	public function isDead():Bool {
		return _isDead;
	}
	
	override public function update(time:GameTime):Void {
		super.update(time);
		
		if (!this.isDead()) {
			if (target.health <= 0) {
				if (seeking) {
					var alternatives:Array<Enemy> = otherEnemies.getNearestEnemies(x, y, 1, seekRange, previousEnemies);
					if (alternatives.length == 0) {
						this.kill();
					} else {
						target = alternatives[0];
						previousEnemies.push(target);
					}
				} else {
					this.kill();
				}
			}
			var xDiff:Float = target.getX() - this.x;
			var yDiff:Float = target.getY() - this.y;
			var direction:Float = Math.atan2(yDiff, xDiff);
			var distance:Float = Math.sqrt(xDiff * xDiff + yDiff * yDiff);
			var possibleMovement:Float = time.elapsedS * speed;
			if (possibleMovement >= distance) {
				// Kill it!
				target.hit(damage);
				this.x += Math.cos(direction) * distance;
				this.y += Math.sin(direction) * distance;
				if (this.pierceAmount <= this.previousEnemies.length) {
					this._isDead = true;
				} else {
					var alternatives:Array<Enemy> = otherEnemies.getNearestEnemies(x, y, 1, seekRange, previousEnemies);
					if (alternatives.length == 0) {
						this.kill();
					} else {
						target = alternatives[0];
						previousEnemies.push(target);
					}
				}
				
			} else {
				this.x += Math.cos(direction) * possibleMovement;
				this.y += Math.sin(direction) * possibleMovement;
			}
		}
		
	}
}