package net.robertboehm.ld24.entities;
import net.robertboehm.ld24.util.GameAssets;
import net.robertboehm.ld24.util.Main;
import org.rygal.BasicGameObject;
import org.rygal.Game;
import org.rygal.GameTime;
import org.rygal.graphic.AnimatedSprite;
import org.rygal.graphic.Animation;
import org.rygal.graphic.Canvas;
import org.rygal.input.KeyboardEvent;
import org.rygal.input.Keys;

/**
 * ...
 * @author Robert Böhm
 */

class PinkiePie extends BasicGameObject {
	
	var gabenKeys:Array<Int>;
	var nextGabenIndex:Int = 0;
	var _gabenShow:Float = -1;
	
	var keys:Array<Int>;
	var nextIndex:Int = 0;
	
	var sprite:AnimatedSprite;
	var game:Game;
	
	public var active:Bool = false;

	public function new(game:Game) {
		super();
		
		this.game = game;
		
		// Gaben keys:
		gabenKeys = [Keys.T, Keys.H, Keys.R, Keys.E, Keys.E];
		
		// Konami Code:
		keys = [Keys.UP, Keys.UP, Keys.DOWN, Keys.DOWN, Keys.LEFT, Keys.RIGHT, Keys.LEFT, Keys.RIGHT, Keys.B, Keys.A];
		
		game.keyboard.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
		sprite = new AnimatedSprite();
		sprite.registerAnimation("run", Animation.fromSpritesheet(50, GameAssets.pinkiePie));
		sprite.loop("run");
	}
	
	private function onKeyDown(e:KeyboardEvent):Void {
		if (_gabenShow < 0) {
			if (e.keyCode == gabenKeys[nextGabenIndex]) {
				nextGabenIndex++;
				if (nextGabenIndex >= gabenKeys.length) {
					_gabenShow = 0;
					nextGabenIndex = 0;
				}
			} else {
				nextGabenIndex = 0;
			}
		}
		
		if (active) {
			if (e.keyCode == Keys.ESCAPE) {
				active = false;
				Main.jukebox.stop();
				Main.jukebox.removeSound(GameAssets.pinkiePieMusic);
				Main.jukebox.addSound(GameAssets.music);
				Main.jukebox.start();
			}
		} else {
			if (e.keyCode == keys[nextIndex]) {
				nextIndex++;
				if (nextIndex >= keys.length) {
					active = true;
					Main.jukebox.stop();
					Main.jukebox.removeSound(GameAssets.music);
					Main.jukebox.addSound(GameAssets.pinkiePieMusic);
					Main.jukebox.start();
					nextIndex = 0;
					this.x = game.width;
				}
			} else {
				nextIndex = 0;
			}
		}
	}
	
	override public function update(time:GameTime):Void {
		super.update(time);
		
		if (_gabenShow >= 0) {
			_gabenShow += time.elapsedS;
			if (_gabenShow > Math.PI) {
				_gabenShow = -1;
			}
		}
		
		if (active) {
			this.x -= time.elapsedS * 100;
			sprite.update(time);
			
			while (this.x <= -sprite.width) {
				this.x += sprite.width;
			}
		}
	}
	
	override public function draw(screen:Canvas):Void {
		super.draw(screen);
		screen.push();
		screen.translate( -screen.xTranslation, -screen.yTranslation);
		
		if (_gabenShow >= 0) {
			screen.draw(GameAssets.gaben, screen.width - Math.sin(_gabenShow) * (GameAssets.gaben.width - 30), 0);
		}
		
		if (active) {
			screen.push();
			screen.translate(this.x, screen.height - sprite.height);
			for (i in 0...(Math.ceil(screen.width / sprite.width) + 1)) {
				sprite.draw(screen);
				screen.translate(sprite.width, 0);
			}
			screen.pop();
		}
		screen.pop();
	}
	
}