package net.robertboehm.ld24.entities;

import net.robertboehm.ld24.util.Enhancements;
import net.robertboehm.ld24.util.GameAssets;
import net.robertboehm.ld24.util.Tile;
import nme.Assets;
import nme.display.BitmapData;
import org.rygal.BasicGameObject;
import org.rygal.graphic.Canvas;
import org.rygal.graphic.Color;
import org.rygal.graphic.Texture;

/**
 * ...
 * @author Robert Böhm
 */

class Map extends BasicGameObject {
	
	public var width(default, null):Int;
	public var height(default, null):Int;
	public var tiles(default, null):Array<Tile>;
	public var time(default, null):Float = 0;
	public var minSpawnRate(default, null):Float = 0;
	public var maxSpawnRate(default, null):Float = 0;
	public var endMinSpawnRate(default, null):Float = 0;
	public var endMaxSpawnRate(default, null):Float = 0;
	public var doubleChance(default, null):Float = 0;
	public var startDelay(default, null):Float = 0;
	public var monsterProgressBase(default, null):Float = 0;
	public var monsterProgressFactor(default, null):Float = 1;
	public var spawnCooldowns(default, null):Array<Float>;
	public var startCrystals(default, null):Int;
	public var enhancements:Enhancements;
	
	private var _tileRandoms(default, null):Array<Float>;
	
	
	public function new(id:String) {
		super();
		
		var bitmapData:BitmapData = Assets.getBitmapData("data/map_" + id + ".png");
		var data:Array<String> = Assets.getText("data/map_" + id + ".txt").split("\n");
		var line:String;
		for (rawLine in data) {
			line = StringTools.trim(rawLine);
			if (StringTools.startsWith(line, "Time:")) {
				var parts:Array<String> = line.split(":");
				if (parts.length == 2) {
					this.time = Std.parseInt(parts[1]) * 60;
				}
			} else if (StringTools.startsWith(line, "MinSpawnrate:")) {
				var parts:Array<String> = line.split(":");
				if (parts.length == 2) {
					this.minSpawnRate = Std.parseFloat(parts[1]);
				}
			} else if (StringTools.startsWith(line, "MaxSpawnrate:")) {
				var parts:Array<String> = line.split(":");
				if (parts.length == 2) {
					this.maxSpawnRate = Std.parseFloat(parts[1]);
				}
			} else if (StringTools.startsWith(line, "DoubleChance:")) {
				var parts:Array<String> = line.split(":");
				if (parts.length == 2) {
					this.doubleChance = Std.parseFloat(parts[1]);
				}
			} else if (StringTools.startsWith(line, "StartDelay:")) {
				var parts:Array<String> = line.split(":");
				if (parts.length == 2) {
					this.startDelay = Std.parseFloat(parts[1]);
				}
			} else if (StringTools.startsWith(line, "StartCrystals:")) {
				var parts:Array<String> = line.split(":");
				if (parts.length == 2) {
					this.startCrystals = Std.parseInt(parts[1]);
				}
			} else if (StringTools.startsWith(line, "EndMinSpawnrate:")) {
				var parts:Array<String> = line.split(":");
				if (parts.length == 2) {
					this.endMinSpawnRate = Std.parseFloat(parts[1]);
				}
			} else if (StringTools.startsWith(line, "EndMaxSpawnrate:")) {
				var parts:Array<String> = line.split(":");
				if (parts.length == 2) {
					this.endMaxSpawnRate = Std.parseFloat(parts[1]);
				}
			} else if (StringTools.startsWith(line, "MonsterProgressBase:")) {
				var parts:Array<String> = line.split(":");
				if (parts.length == 2) {
					this.monsterProgressBase = Std.parseFloat(parts[1]);
				}
			} else if (StringTools.startsWith(line, "MonsterProgressFactor:")) {
				var parts:Array<String> = line.split(":");
				if (parts.length == 2) {
					this.monsterProgressFactor = Std.parseFloat(parts[1]);
				}
			}
		}
		
		this.tiles = new Array<Tile>();
		this._tileRandoms = new Array<Float>();
		this.spawnCooldowns = new Array<Float>();
		this.width = bitmapData.width;
		this.height = bitmapData.height;
		
		
		var length:Int = this.width * this.height;
		
		// Write random numbers for each tile as well as the tiles themselves:
		// (Write the last tile in the end so it doesn't have to allocate more space after every push)
		this.tiles[length - 1] = Tile.EMPTY;
		this.spawnCooldowns[length - 1] = Math.random();
		this._tileRandoms[length - 1] = Math.random();
		for (i in 0...length - 1) {
			this._tileRandoms[i] = Math.random();
			this.spawnCooldowns[i] = Math.random();
		}
		for (x in 0...width) {
			for (y in 0...height) {
				this.setTile(x, y, switch(bitmapData.getPixel(x, y)) {
					case Color.BLACK: Tile.ENEMY_SPAWN;
					case Color.LIME: Tile.BIG_CRYSTAL;
					case Color.BLUE: Tile.SMALL_CRYSTAL;
					case Color.CYAN: Tile.EXPLORER_CRYSTAL;
					default: Tile.EMPTY;
				});
			}
		}
	}
	
	
	public inline function setTile(x:Int, y:Int, tile:Tile):Void {
		this.tiles[x + (y * width)] = tile;
	}
	
	public inline function getTile(x:Int, y:Int):Tile {
		return this.tiles[x + (y * width)];
	}
	
	public inline function getTileRandom(x:Int, y:Int):Float {
		return this._tileRandoms[x + (y * width)];
	}
	
	override public function draw(screen:Canvas):Void {
		super.draw(screen);
		
		var texture:Texture;
		var rnd:Int;
		var tx:Int;
		var ty:Int;
		var t:Tile;
		for (x in 0...width) {
			for (y in 0...height) {
				tx = x * GameAssets.spritesheet.spriteWidth;
				ty = y * GameAssets.spritesheet.spriteHeight;
				
				switch(Std.int(getTileRandom(x, y) * 4)) {
					case 1: texture = GameAssets.spritesheet.getTexture(1, 0);
					case 2: texture = GameAssets.spritesheet.getTexture(0, 1);
					case 3: texture = GameAssets.spritesheet.getTexture(1, 1);
					default: texture = GameAssets.spritesheet.getTexture(0, 0);
				}
				screen.draw(texture, tx, ty);
				
				t = getTile(x, y);
				if (t == SMALL_CRYSTAL || (t == EXPLORER_CRYSTAL && enhancements.explorer)) {
					screen.draw(GameAssets.spritesheet.getTexture(2, 0), tx, ty);
				} else if (t == ENEMY_SPAWN) {
					screen.draw(GameAssets.spritesheet.getTexture(2, 1), tx, ty);
				}
			}
		}
	}
	
	public inline function getPixelWidth():Int {
		return this.width * GameAssets.spritesheet.spriteWidth;
	}
	
	public inline function getPixelHeight():Int {
		return this.height * GameAssets.spritesheet.spriteHeight;
	}
	
}