package net.robertboehm.ld24.entities;

import net.robertboehm.ld24.entities.enemies.Enemy;

/**
 * ...
 * @author Robert Böhm
 */

class EnemyList extends CoolList<Enemy> {
	
	public function new() {
		super();
	}
	
	
	public function getNearestEnemies(x:Float, y:Float, amount:Int = 1, range:Float = 0, ?exclude:Array<Enemy>):Array<Enemy> {
		var list:Array<Enemy> = new Array<Enemy>();
		for (i in 0...amount) {
			var minDistance:Float = 0;
			var minDistanceEnemy:Enemy = null;
			for (enemy in objects) {
				if (enemy.isDead())
					continue;
				
				var contained:Bool = false;
				for (e in list) {
					if (e == enemy) {
						contained = true;
						break;
					}
				}
				if (exclude != null && !contained) {
					for (e in exclude) {
						if (e == enemy) {
							contained = true;
							break;
						}
					}
				}
				if (!contained) {
					var distance:Float = enemy.getSquaredDistanceTo(x, y);
					if (minDistanceEnemy == null || minDistance > distance) {
						minDistance = distance;
						minDistanceEnemy = enemy;
					}
				}
			}
			if (minDistanceEnemy != null && (range <= 0 || Math.sqrt(minDistance) <= range)) {
				list.push(minDistanceEnemy);
			} else {
				break;
			}
		}
		return list;
	}
	
}