package net.robertboehm.ld24.entities;

import haxe.FastList;
import net.robertboehm.ld24.util.Livable;
import org.rygal.BasicGameObject;
import org.rygal.GameObject;
import org.rygal.GameTime;
import org.rygal.graphic.Canvas;


/**
 * ...
 * @author Robert Böhm
 */

class CoolList<T:(Livable, GameObject)> extends BasicGameObject {
	
	private var objects:FastList<T>;
	
	
	public function new() {
		super();
		
		objects = new FastList<T>();
	}
	
	
	public function clear():Void {
		objects.head = null;
	}
	
	public function spawn(object:T):Void {
		objects.add(object);
	}
	
	override public function update(time:GameTime):Void {
		super.update(time);
		
		var previous:FastCell<T> = null;
		var current:FastCell<T> = objects.head;
		
		while (current != null) {
			current.elt.update(time);
			if (current.elt.isDead()) {
				if (previous == null) {
					if (objects.head == current) {
						// Still the first element
						objects.head = current.next;
					} else {
						// Another element was added
						previous = objects.head;
						while (previous.next != null && previous.next != current) {
							previous = previous.next;
						}
						previous.next = current.next;
					}
				} else {
					previous.next = current.next;
				}
			}
			previous = current;
			current = current.next;
		}
	}
	
	override public function draw(screen:Canvas):Void {
		super.draw(screen);
		
		for (object in objects) {
			object.draw(screen);
		}
	}
	
}