package net.robertboehm.ld22;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamedMapGrid {
	
	private StreamedMapGrid() {}
	
	public static Mapgrid fromStream(MapProvider mapProvider, InputStream is) throws IOException {
		try(DataInputStream dis = new DataInputStream(is)) {
			Mapgrid grid = new Mapgrid(dis.readInt(), dis.readInt(), dis.readInt(), dis.readInt(), dis.readInt());
			for(int y = 0; y < grid.height; y++) {
				for(int x = 0; x < grid.width; x++) {
					grid.setGridId(x, y, dis.readInt());
				}
			}
			grid.feed(mapProvider);
			return grid;
		}
	}

}
