package net.robertboehm.ld22;

import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.state.StateBasedGame;

public class MapgridState extends IngameState {

	public static final int MAP1_STATE_ID = 10;
	public static final int MAP2_STATE_ID = 11;
	public static final int MAP3_STATE_ID = 12;

	private final Mapgrid mapGrid;
	private final int stateId;
	private int currentGridId;

	public MapgridState(Mapgrid mapGrid, int stateId) {
		super(mapGrid.getSpawnMap(), mapGrid.getSpawnX()
				* mapGrid.getSpawnMap().tileset.tileWidth
				+ mapGrid.getSpawnMap().tileset.tileWidth / 2
				- GameAssets.getPlayerCharset().tileWidth / 2, mapGrid
				.getSpawnY()
				* mapGrid.getSpawnMap().tileset.tileHeight
				+ mapGrid.getSpawnMap().tileset.tileHeight
				- GameAssets.getPlayerCharset().tileHeight - 1);
		this.currentGridId = mapGrid.getSpawnMapId();
		this.mapGrid = mapGrid;
		this.stateId = stateId;
	}

	public static int findStateId(String mapgrid) {
		switch (mapgrid) {
		case "map1":
			return MAP1_STATE_ID;
		case "map2":
			return MAP2_STATE_ID;
		case "map3":
			return MAP3_STATE_ID;
		}
		return -1;
	}

	@Override
	public int getID() {
		return stateId;
	}

	@Override
	public void init(GameContainer container, StateBasedGame game)
			throws SlickException {
		super.init(container, game);
	}

	@Override
	public void render(GameContainer container, StateBasedGame game, Graphics g)
			throws SlickException {
		super.render(container, game, g);

		if (!AreYouStillThere.message.getText().isEmpty()) {
			AreYouStillThere.messageBackground.draw(container.getWidth() / 2
					- AreYouStillThere.messageBackground.getWidth() / 2, 32);
			AreYouStillThere.message.draw(container.getWidth() / 2
					- AreYouStillThere.messageBackground.getWidth() / 2 + 18,
					50);
		}
	}

	@Override
	public void update(GameContainer container, StateBasedGame game, int delta)
			throws SlickException {
		super.update(container, game, delta);
	}

	@Override
	public boolean intersects(Shape s) {
		Rectangle b = getMapBoundings();
		if (b.intersects(s)) {
			return super.intersects(s);
		} else if(s == player.getShape()) {
			int neighbor = -1;
			float pX = player.getX();
			float pY = player.getY();
			do {
				if (s.getMinX() >= b.getWidth()) {
					neighbor = mapGrid.getNeighborId(this.currentGridId,
							Mapgrid.EAST);
					if (neighbor != -1) {
						pX = 1 - s.getWidth();
						break;
					}
				}
				if (s.getMinX() <= 0) {
					neighbor = mapGrid.getNeighborId(this.currentGridId,
							Mapgrid.WEST);
					if (neighbor != -1) {
						pX = mapGrid.getMapById(neighbor).width
								* getCurrentMap().tileset.tileWidth - 1;
						break;
					}
				}
				if (s.getMinY() >= b.getHeight()) {
					neighbor = mapGrid.getNeighborId(this.currentGridId,
							Mapgrid.SOUTH);
					if (neighbor != -1) {
						pY = 1 - s.getHeight();
						break;
					}
				}
				if (s.getMaxY() <= 0) {
					neighbor = mapGrid.getNeighborId(this.currentGridId,
							Mapgrid.NORTH);
					if (neighbor != -1) {
						pY = mapGrid.getMapById(neighbor).height
								* getCurrentMap().tileset.tileHeight - 1;
						break;
					}
				}
			} while (false);

			if (neighbor != -1) {
				currentGridId = neighbor;
				enterMap(mapGrid.getMapById(neighbor), pX, pY);
				return false;
			} else {
				return true;
			}
		} else {
			return true;
		}
	}

}
