package net.robertboehm.ld22;

import org.newdawn.slick.Renderable;

public class MapRenderer implements Renderable {

	private GameMap map;

	public MapRenderer() {
		this(null);
	}

	public MapRenderer(GameMap map) {
		this.map = map;
	}

	public void setMap(GameMap map) {
		this.map = map;
	}

	@Override
	public void draw(float xOffset, float yOffset) {
		if (map == null)
			return;
		
		for(GameMapLayer layer : map.layers) {
			for (int tx = 0; tx < map.width; tx++) {
				for (int ty = 0; ty < map.height; ty++) {
					Tile t = layer.getTile(tx, ty);
					if(t != null)
						t.draw(xOffset, yOffset);
				}
			}
		}
	}

}
