package net.robertboehm.ld22;

import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;

public class MainMenuState extends BasicGameState {

	public static final int STATE_ID = 1;
	public static final int NEWGAME_STATE_ID = CutsceneState.INTRO_STATE_ID;

	public static final int ZOOM = 2;
	public static final int TILE_WIDTH = 16 * ZOOM;
	public static final int TILE_HEIGHT = 16 * ZOOM;

	public static final String ASSET_TILEIMAGE = "/assets/tiles.png";
	public static final String ASSET_TILEPROPERTIES = "/assets/tiles.txt";
	public static final String ASSET_MENUMAP = "menu";

	public static final String ASSETNAME_TILES = "tiles";

	private Image logo;
	private StateBasedGame game;

	MapRenderer mapRenderer;

	@Override
	public int getID() {
		return STATE_ID;
	}

	@Override
	public void mousePressed(int button, int x, int y) {
		if (button == Input.MOUSE_LEFT_BUTTON) {
			if (y >= TILE_HEIGHT * 7 && y <= TILE_HEIGHT * 9
					&& x >= TILE_WIDTH * 2 && x <= TILE_WIDTH * 7) {
				GameAssets.stopMusic();
				game.enterState(NEWGAME_STATE_ID, new FadeOutTransition(
						Color.black, 600), new FadeInTransition(Color.black,
						600));
			}
		}
	}

	@Override
	public void init(GameContainer container, StateBasedGame game)
			throws SlickException {
		GameAssets.preloadImages();
		AreYouStillThere.messageBackground = GameAssets.getImage("msgbg");
		
		this.game = game;
		GameMap map = GameAssets.getMap(ASSET_MENUMAP);
		logo = new Image(
				MainMenuState.class.getResourceAsStream("/assets/logo.png"),
				"/assets/logo.png", false);
		mapRenderer = new MapRenderer(map);
		
		GameAssets.playMusic();
	}

	@Override
	public void render(GameContainer container, StateBasedGame game, Graphics g)
			throws SlickException {
		g.clear();
		g.setColor(new Color(0x200009));
		g.fillRect(0, 0, container.getWidth(), container.getHeight());
		g.setColor(Color.white);
		g.fillRect(TILE_WIDTH * 12, TILE_HEIGHT * 13, TILE_WIDTH * 7
				* AreYouStillThere.volume, TILE_HEIGHT);
		mapRenderer.draw(0, 0);
		logo.draw(container.getWidth() / 2 - logo.getWidth() / 2, 80);
	}

	@Override
	public void update(GameContainer container, StateBasedGame game, int delta)
			throws SlickException {
		Input input = container.getInput();
		if (input.isMouseButtonDown(Input.MOUSE_LEFT_BUTTON)) {
			if (input.getMouseX() >= TILE_WIDTH * 12
					&& input.getMouseX() <= TILE_WIDTH * 19
					&& input.getMouseY() >= TILE_HEIGHT * 13
					&& input.getMouseY() <= TILE_HEIGHT * 14) {
				AreYouStillThere.volume = (input.getMouseX() - TILE_WIDTH * 12f)
						/ (TILE_WIDTH * 7);
				if(AreYouStillThere.volume < 0.1) {
					AreYouStillThere.volume = 0;
				}
				GameAssets.refreshVolume();
			}
		}
	}

}
