package net.robertboehm.ld22;

import org.newdawn.slick.Image;
import org.newdawn.slick.Renderable;

public class Label implements Renderable {

	private static final String[] charset = new String[] {
			"ABCDEFGHIJKLMNOPQRSTUVWXYZ/\\&%",
			"abcdefghijklmnopqrstuvwxyz,_*+",
			"0123456789.?!-~#;:'\"()[]{}=<>|"
			};

	private static final int CHAR_WIDTH = 6 * AreYouStillThere.ZOOM;
	private static final int CHAR_HEIGHT = 13 * AreYouStillThere.ZOOM;

	private static Image charsetImage = null;

	private String content;

	public Label() {
		this("");
	}

	public Label(String content) {
		this.content = content;
	}

	public void setText(String content) {
		this.content = content;
	}

	public String getText() {
		return this.content;
	}

	@Override
	public void draw(float xo, float yo) {
		if (charsetImage == null)
			charsetImage = GameAssets.getImage("charset");

		int x = 0;
		int y = 0;
		for (int i = 0; i < content.length(); i++) {
			char c = content.charAt(i);
			if (c == '\n' || c == '$') {
				y++;
				x = 0;
			} else if (c == ' ') {
				x++;
			} else {
				for (int csy = 0; csy < charset.length; csy++) {
					int csx = charset[csy].indexOf(c);
					if (csx != -1) {
						charsetImage.draw(xo + x * CHAR_WIDTH, yo + y
								* CHAR_HEIGHT, xo + (x + 1) * CHAR_WIDTH, yo
								+ (y + 1) * CHAR_HEIGHT, csx * CHAR_WIDTH, csy
								* CHAR_HEIGHT, (csx + 1) * CHAR_WIDTH,
								(csy + 1) * CHAR_HEIGHT);
						x++;
						break;
					}
				}
			}
		}
	}

}
