package net.robertboehm.ld22;

import org.newdawn.slick.Image;

public class GameTileset {
	
	public static final int DEFAULT_TILE_WIDTH = 16 * AreYouStillThere.ZOOM;
	public static final int DEFAULT_TILE_HEIGHT = 16 * AreYouStillThere.ZOOM;

	public final TileTemplate[] tiles;
	public final int tileWidth;
	public final int tileHeight;
	public final int width;
	public final int height;

	public GameTileset(Image image, TileProperties tileProperties) {
		this(image, tileProperties, DEFAULT_TILE_WIDTH, DEFAULT_TILE_HEIGHT);
	}

	public GameTileset(Image image, TileProperties tileProperties, int tileWidth, int tileHeight) {
		this.tileWidth = tileWidth;
		this.tileHeight = tileHeight;
		this.width = image.getWidth() / tileWidth;
		this.height = image.getHeight() / tileHeight;
		this.tiles = new TileTemplate[width * height];
		for (int x = 0; x < width; x++) {
			for (int y = 0; y < height; y++) {
				tiles[y * width + x] = new TileTemplate(image.getSubImage(
						x * tileWidth, y * tileHeight, tileWidth, tileHeight),
						tileProperties.getCollisionMode(x, y), this);
			}
		}
	}

	public Tile getTile(int id, int x, int y) {
		return tiles[id].getTile(x * tileWidth, y * tileHeight);
	}

}
