package net.robertboehm.ld22;

public class GameMapLayer {
	
	public final Tile[] data;
	public final int width;
	public final int height;
	public final boolean ignoresCollisions;
	
	public GameMapLayer(Tile[] data, int width, int height, boolean ignoreCollisions) {
		this.data = data;
		this.width = width;
		this.height = height;
		this.ignoresCollisions = ignoreCollisions;
	}
	
	public Tile getTile(int x, int y) {
		int tid = GameMap.getTileId(x, y, width);
		return (tid >= 0 && tid < data.length) ? data[tid] : null;
	}
	
}
