package net.robertboehm.ld22;

import org.newdawn.slick.Image;

public class GameCharset {

	public static final int IMAGE_STANDING_R0 = 0;
	public static final int IMAGE_STANDING_R1 = 1;
	public static final int IMAGE_STANDING_L0 = 2;
	public static final int IMAGE_STANDING_L1 = 3;
	
	public static final int IMAGE_RUNNING_R0 = 4;
	public static final int IMAGE_RUNNING_R1 = 5;
	public static final int IMAGE_RUNNING_R2 = 6;
	public static final int IMAGE_RUNNING_R3 = 7;
	
	public static final int IMAGE_RUNNING_L0 = 8;
	public static final int IMAGE_RUNNING_L1 = 9;
	public static final int IMAGE_RUNNING_L2 = 10;
	public static final int IMAGE_RUNNING_L3 = 11;

	public static final int IMAGE_FALLING_L = 12;
	public static final int IMAGE_FALLING = 13;
	public static final int IMAGE_FALLING_R = 14;
	
	public static final int IMAGE_AMOUNT = 15;
	
	public final Image[] images = new Image[IMAGE_AMOUNT];
	public final int tileWidth;
	public final int tileHeight;
	
	public GameCharset(Image image) {
		this(image, image.getWidth() / 4, image.getHeight() / 4);
	}
	
	public GameCharset(Image image, int tileWidth, int tileHeight) {
		this.tileWidth = tileWidth;
		this.tileHeight = tileHeight;
		
		images[IMAGE_STANDING_R0] = image.getSubImage(tileWidth * 0, tileHeight * 0, tileWidth, tileHeight);
		images[IMAGE_STANDING_R1] = image.getSubImage(tileWidth * 1, tileHeight * 0, tileWidth, tileHeight);
		images[IMAGE_STANDING_L0] = image.getSubImage(tileWidth * 2, tileHeight * 0, tileWidth, tileHeight);
		images[IMAGE_STANDING_L1] = image.getSubImage(tileWidth * 3, tileHeight * 0, tileWidth, tileHeight);
		
		images[IMAGE_RUNNING_R0] = image.getSubImage(tileWidth * 0, tileHeight * 1, tileWidth, tileHeight);
		images[IMAGE_RUNNING_R1] = image.getSubImage(tileWidth * 1, tileHeight * 1, tileWidth, tileHeight);
		images[IMAGE_RUNNING_R2] = image.getSubImage(tileWidth * 2, tileHeight * 1, tileWidth, tileHeight);
		images[IMAGE_RUNNING_R3] = image.getSubImage(tileWidth * 3, tileHeight * 1, tileWidth, tileHeight);
		
		images[IMAGE_RUNNING_L0] = image.getSubImage(tileWidth * 0, tileHeight * 2, tileWidth, tileHeight);
		images[IMAGE_RUNNING_L1] = image.getSubImage(tileWidth * 1, tileHeight * 2, tileWidth, tileHeight);
		images[IMAGE_RUNNING_L2] = image.getSubImage(tileWidth * 2, tileHeight * 2, tileWidth, tileHeight);
		images[IMAGE_RUNNING_L3] = image.getSubImage(tileWidth * 3, tileHeight * 2, tileWidth, tileHeight);
		
		images[IMAGE_FALLING_L] = image.getSubImage(tileWidth * 0, tileHeight * 3, tileWidth, tileHeight);
		images[IMAGE_FALLING] = image.getSubImage(tileWidth * 1, tileHeight * 3, tileWidth, tileHeight);
		images[IMAGE_FALLING_R] = image.getSubImage(tileWidth * 2, tileHeight * 3, tileWidth, tileHeight);
	}

	public Image getImage(int id) {
		return images[id];
	}
	
}
