package net.robertboehm.ld22;

import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

public class CutsceneState extends IngameState {

	public static final String CUTSCENE_INTRO = "intro";
	public static final String CUTSCENE_INTRO_MAP = "intro";
	public static final int CUTSCENE_INTRO_SPAWNX = 320;
	public static final int CUTSCENE_INTRO_SPAWNY = 240;

	public static final int INTRO_STATE_ID = 100;

	private boolean alreadyStarted = false;
	private final String cutscene;
	private final int stateId;

	public CutsceneState(int stateId, String cutscene) {
		this.stateId = stateId;
		this.cutscene = cutscene;
	}

	@Override
	public int getID() {
		return stateId;
	}

	@Override
	public void init(GameContainer container, StateBasedGame game)
			throws SlickException {
		super.init(container, game);

		new GameScript(game, cutscene + "_init", this).run();
	}

	@Override
	public void update(GameContainer container, StateBasedGame game, int delta)
			throws SlickException {
		super.update(container, game, delta);

		if (!alreadyStarted) {
			alreadyStarted = true;
			new GameScript(game, cutscene).start();
		}
	}

	@Override
	public void render(GameContainer container, StateBasedGame game, Graphics g)
			throws SlickException {
		super.render(container, game, g);
		
		if (!AreYouStillThere.message.getText().isEmpty()) {
			AreYouStillThere.messageBackground.draw(container.getWidth() / 2
					- AreYouStillThere.messageBackground.getWidth() / 2, 32);
			AreYouStillThere.message.draw(container.getWidth() / 2
					- AreYouStillThere.messageBackground.getWidth() / 2 + 18,
					50);
		}
	}


}
