package net.robertboehm.ld22;

import org.newdawn.slick.Renderable;
import org.newdawn.slick.geom.Rectangle;

public class Character extends CollisionEntity implements Renderable {
	
	public static final int MOVING_NONE = 0,
			MOVING_LEFT = -1,
			MOVING_RIGHT = 1;
	
	private final GameCharset charset;
	private int movingMode = MOVING_NONE;
	private long lastFrame = System.currentTimeMillis();
	private float standingProgress = 0;
	private float runningProgress = 0;
	
	public Character(GameCharset charset, IEnvironment collisionEnvironment) {
		super(new Rectangle(0, 0, charset.tileWidth, charset.tileHeight), collisionEnvironment);
		this.charset = charset;
		this.collisionEnvironment = collisionEnvironment;
	}
	
	public void setMode(int movingMode) {
		this.movingMode = movingMode;
	}

	@Override
	public void draw(float x, float y) {
		long now = System.currentTimeMillis();
		long delta = now - lastFrame;
		lastFrame = now;

		standingProgress += delta / 1000.0f;
		while(standingProgress >= 1f)
			standingProgress -= 1f;

		runningProgress += delta / 750.0f;
		while(runningProgress >= 1f)
			runningProgress -= 1f;
		
		if(isStanding()) {
			if(movingMode == MOVING_LEFT) {
				charset.getImage((int)(runningProgress * 4) + GameCharset.IMAGE_RUNNING_L0).draw(x + getX(),
						y + getY());
			} else if(movingMode == MOVING_RIGHT) {
				charset.getImage((int)(runningProgress * 4) + GameCharset.IMAGE_RUNNING_R0).draw(x + getX(),
						y + getY());
			} else {
				charset.getImage((int)(standingProgress * 2) + GameCharset.IMAGE_STANDING_R0).draw(x + getX(),
						y + getY());
			}
		} else {
			if(velocityX > 1f) {
				charset.getImage(GameCharset.IMAGE_FALLING_R).draw(x + getX(), y + getY());
			} else if(velocityX < -1f) {
				charset.getImage(GameCharset.IMAGE_FALLING_L).draw(x + getX(), y + getY());
			} else {
				charset.getImage(GameCharset.IMAGE_FALLING).draw(x + getX(), y + getY());
			}
		}
	}
	
}
