package net.robertboehm.ld22;

import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

public class AreYouStillThere extends StateBasedGame {
	
	private static AreYouStillThere lastInstance;

	public static final int ZOOM = 2;
	public static final String ASSET_MAPGRID_1 = "map1";
	public static final String ASSET_INTROMAP = "intro";
	public static boolean movementAllowed = true;
	public static boolean showEnding = false;

	public static float volume = 1.0f;

	public static Image messageBackground = null;
	public static final Label message = new Label();

	public static void main(String[] args) {
		AppGameContainer container;
		try {
			container = new AppGameContainer(new AreYouStillThere());
			container.setDisplayMode(640, 480, false);
			container.setVSync(true);
			container.start();
		} catch (SlickException exception) {
			exception.printStackTrace();
		}
	}

	public AreYouStillThere() {
		super("Are you still there?");
		lastInstance = this;
	}
	
	public static AreYouStillThere getInstance() {
		return lastInstance;
	}

	@Override
	public void initStatesList(GameContainer container) throws SlickException {
		container.setShowFPS(false);
		this.addState(new MainMenuState());
		this.addState(new MapgridState(GameAssets.getMapgrid(ASSET_MAPGRID_1), MapgridState.MAP1_STATE_ID));
		this.addState(new CutsceneState(CutsceneState.INTRO_STATE_ID, CutsceneState.CUTSCENE_INTRO));
		this.enterState(MainMenuState.STATE_ID);
	}
	
}
